<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

$cat = vB_Template::create('dbtech_downloads_listings');

($hook = vBulletinHook::fetch_hook('dbtech_downloads_listings_start')) ? eval($hook) : false;

$catid = $vbulletin->input->clean_gpc('g', 'catid', TYPE_INT);

$listings_get = $db->query_read("
	SELECT filegroup.*, cat.*, filegroup.image AS image, user.username, user.userid FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup AS filegroup
	INNER JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = filegroup.userid)
	LEFT JOIN " . TABLE_PREFIX . "dbtech_downloads_categories AS cat ON (cat.catid = filegroup.categoryid)
	WHERE filegroup.categoryid = $catid 
	ORDER BY filegroup.updated DESC
");

$listingbits 	= '';
$subbits 	= '';

foreach ($vbulletin->dbtech_downloads_categories AS $categoryid => $category) {
	if ($categoryid == $catid || $category['parentid'] == $catid) {
		$permissions 	= unserialize($category['permissions']);
		$secondary		= explode(',', $vbulletin->userinfo['membergroupids']);
	
		$canview = false;
		$subview = array();
		foreach ($secondary AS $ugid) {
			if (in_array($ugid, (array)$permissions['view'])) {
				if ($categoryid == $catid) {
					$canview = true;
				} else {
					$subview[$category['parentid']] = true;
				}
			}
		}
	}
	
	if ($category['parentid'] == $catid && (in_array($vbulletin->userinfo['usergroupid'], (array)$permissions['view']) || $subview[$category['parentid']] == true)) {
		$sub = vB_Template::create('dbtech_downloads_listings_sub_bits');
		$category['catname'] = unhtmlspecialchars($category['catname']);

		$sub->register('sub', $category);

		$subbits .= $sub->render();
	}
}

require_once (DIR . '/includes/class_bbcode.php');

$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list('', true));

if ($db->num_rows($listings_get) > 0) {
	$i = 0;
	
	while ($listings = $db->fetch_array($listings_get)) {
		$permissions 	= unserialize($listings['permissions']);
		$secondary		= explode(',', $vbulletin->userinfo['membergroupids']);
		
		$canview = false;
		foreach ($secondary AS $ugid) {
			if (in_array($ugid, $permissions['view'])) {
				$canview = true;
			}
		}
		
		if (!empty($permissions) && (Downloads::is_mod() == true || (in_array($vbulletin->userinfo['usergroupid'], $permissions['view']) || $canview == true))) {
			$list = vB_Template::create('dbtech_downloads_listings_bits');
			
			$catid = $listings['categoryid'];
			
			if ($i == 0) {
				if ($listings['parentid'] > 0) {
					$navbits[$vbulletin->options['dbtech_downloads_link'] . '.php?do=listings&catid=' . $listings['parentid']] = $vbulletin->dbtech_downloads_categories[$listings['parentid']]['catname'];	
				}

				$navbits[] = $listings['catname'];
				
				$i++;
			}
			
			if (strlen($listings['groupdesc']) > 200) {
				$listings['groupdesc'] = substr($listings['groupdesc'], 0, 200);
				$listings['groupdesc'] .= '...';
			}
			
			$listings['rating']			= Downloads::beautify_rating($listings['rating']);
			$listings['groupdesc'] 	= $bbcode->parse(strip_tags(Downloads::convert_wysiwyg_html_to_bbcode($listings['groupdesc'])), 'nonforum', true, false);
			$listings['updated'] 		= vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $listings['updated'], true , false);
			
			$list->register('listings', $listings);
			
			$listingbits .= $list->render();
		} else {
			print_no_permission();
		}
	}
} else {
	$navbits[] = $vbphrase['dbtech_downloads_file_listings'];
}

($hook = vBulletinHook::fetch_hook('dbtech_downloads_listings_complete')) ? eval($hook) : false;

$cat->register('catid', $catid);
$cat->register('subbits', $subbits);
$cat->register('listings', $listingbits);

$HTML .= $cat->render();

?>